<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ניהול סידור - דף ראשי</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1000px; /* הרחבתי מעט כדי ש-3 כרטיסים ייכנסו יפה */
            margin: 0 auto;
        }
        .header {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            margin-bottom: 30px;
            text-align: center;
        }
        h1 {
            color: #667eea;
            font-size: 2.5em;
            margin-bottom: 10px;
        }
        .welcome {
            color: #718096;
            font-size: 1.2em;
        }
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }
        .card {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            text-align: center;
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 250px; /* גובה אחיד לכרטיסים */
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 50px rgba(0,0,0,0.3);
        }
        .card-icon {
            font-size: 4em;
            margin-bottom: 20px;
        }
        .card-title {
            font-size: 1.5em;
            font-weight: bold;
            color: #2d3748;
            margin-bottom: 10px;
        }
        .card-description {
            color: #718096;
            font-size: 0.95em;
        }
        .logout-btn {
            background: white;
            padding: 15px 30px;
            border-radius: 8px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
            text-align: center;
            display: block;
            max-width: 300px;
            margin: 30px auto 0;
            text-decoration: none;
            color: #f56565;
            font-weight: bold;
            transition: all 0.3s;
        }
        .logout-btn:hover {
            background: #f56565;
            color: white;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📖 ניהול סידור תפילה</h1>
            <p class="welcome">שלום <?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?>! בחר את הפעולה הרצויה</p>
        </div>

        <div class="cards">
            <a href="dedication_manage.php" class="card">
                <div class="card-icon">🕯️</div>
                <div class="card-title">ניהול הקדשה</div>
                <div class="card-description">עדכון שם המנוח/ה המוקדש/ת</div>
            </a>

            <a href="blessings_admin.php" class="card">
                <div class="card-icon">🍎</div>
                <div class="card-title">ניהול ברכות</div>
                <div class="card-description">הוספה, עריכה ומחיקה של מאכלים וברכותיהם</div>
            </a>

            <a href="stats_dashboard.php" class="card">
                <div class="card-icon">📊</div>
                <div class="card-title">סטטיסטיקות שימוש</div>
                <div class="card-description">דוח התקנות, משתמשים פעילים ולוג כניסות</div>
            </a>
        </div>

        <a href="logout.php" class="logout-btn" onclick="return confirm('האם להתנתק?')">
            🚪 התנתק מהמערכת
        </a>
    </div>
</body>
</html>