<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}

/**
 * Blessings Add - הוספת מאכל חדש
 */
require 'config.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $food_name = trim($_POST['food_name']);
    $food_name_normalized = trim($_POST['food_name_normalized']);
    $blessing_before = trim($_POST['blessing_before']);
    $blessing_after = trim($_POST['blessing_after']);
    $category = trim($_POST['category']);
    $notes = trim($_POST['notes']);

    // ולידציה
    if (empty($food_name) || empty($blessing_before) || empty($blessing_after) || empty($category)) {
        $error = 'אנא מלא את כל השדות החובה!';
    } else {
        // אם לא הוזן normalized - השתמש בשם הרגיל
        if (empty($food_name_normalized)) {
            $food_name_normalized = $food_name;
        }

        try {
            $stmt = $pdo->prepare("
                INSERT INTO blessings 
                (food_name, food_name_normalized, blessing_before, blessing_after, category, notes) 
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([
                $food_name,
                $food_name_normalized,
                $blessing_before,
                $blessing_after,
                $category,
                $notes
            ]);
            header('Location: blessings_admin.php?msg=added');
            exit;
        } catch (PDOException $e) {
            $error = 'שגיאה בהוספת המאכל: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>הוסף מאכל חדש - ברכות</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 40px;
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
            font-size: 2.5em;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s;
        }
        .back-link:hover {
            color: #5568d3;
        }
        .form-group {
            margin-bottom: 25px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #2d3748;
        }
        .required {
            color: #f56565;
        }
        input[type="text"],
        textarea,
        select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 16px;
            font-family: inherit;
            transition: border-color 0.3s;
        }
        input:focus,
        textarea:focus,
        select:focus {
            outline: none;
            border-color: #667eea;
        }
        textarea {
            min-height: 100px;
            resize: vertical;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        .alert-error {
            background: #fed7d7;
            color: #742a2a;
            border: 2px solid #fc8181;
        }
        .btn {
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #667eea;
            color: white;
            width: 100%;
        }
        .btn-primary:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .help-text {
            font-size: 13px;
            color: #718096;
            margin-top: 5px;
        }
        .categories-hint {
            background: #edf2f7;
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
            font-size: 14px;
            color: #4a5568;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="blessings_admin.php" class="back-link">← חזרה לרשימה</a>
        
        <h1>➕ הוסף מאכל חדש</h1>

        <?php if ($error): ?>
            <div class="alert alert-error">⚠️ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <label>שם המאכל <span class="required">*</span></label>
                <input type="text" name="food_name" required 
                       value="<?= isset($_POST['food_name']) ? htmlspecialchars($_POST['food_name']) : '' ?>"
                       placeholder="לדוגמה: תפוח עץ">
                <div class="help-text">השם כפי שיוצג למשתמש (עם ניקוד אם יש)</div>
            </div>

            <div class="form-group">
                <label>שם מנורמל (לחיפוש)</label>
                <input type="text" name="food_name_normalized" 
                       value="<?= isset($_POST['food_name_normalized']) ? htmlspecialchars($_POST['food_name_normalized']) : '' ?>"
                       placeholder="לדוגמה: תפוח עץ">
                <div class="help-text">אותו שם בלי ניקוד (אופציונלי - אם ריק יעתיק מהשם הרגיל)</div>
            </div>

            <div class="form-group">
                <label>ברכה ראשונה <span class="required">*</span></label>
                <textarea name="blessing_before" required 
                          placeholder="בָּרוּךְ אַתָּה ה' אֱלֹהֵינוּ מֶלֶךְ הָעוֹלָם..."><?= isset($_POST['blessing_before']) ? htmlspecialchars($_POST['blessing_before']) : '' ?></textarea>
            </div>

            <div class="form-group">
                <label>ברכה אחרונה <span class="required">*</span></label>
                <textarea name="blessing_after" required 
                          placeholder="בּוֹרֵא נְפָשׁוֹת רַבּוֹת וְחֶסְרוֹנָן..."><?= isset($_POST['blessing_after']) ? htmlspecialchars($_POST['blessing_after']) : '' ?></textarea>
            </div>

            <div class="form-group">
                <label>קטגוריה <span class="required">*</span></label>
                <select name="category" required>
                    <option value="">-- בחר קטגוריה --</option>
                    <option value="המוציא - לחם">המוציא - לחם</option>
                    <option value="מזונות - מאפים מקמח">מזונות - מאפים מקמח</option>
                    <option value="הגפן - יין וענבים">הגפן - יין וענבים</option>
                    <option value="העץ - פירות עץ">העץ - פירות עץ</option>
                    <option value="העץ - זית, תאנה, תמר, רימון, ענבים (שבעת המינים)">העץ - שבעת המינים</option>
                    <option value="האדמה - ירקות ופירות אדמה">האדמה - ירקות ופירות אדמה</option>
                    <option value="שהכל - שאר המזונות">שהכל - שאר המזונות</option>
                </select>
                
                <div class="categories-hint">
                    <strong>רמז:</strong><br>
                    • לחם/חלה/מצה → המוציא<br>
                    • עוגה/פיצה/פסטה → מזונות<br>
                    • יין/מיץ ענבים → הגפן<br>
                    • תפוח/בננה/מנגו → העץ (רגיל)<br>
                    • זית/תאנה/תמר/רימון/ענבים → העץ (שבעת המינים)<br>
                    • עגבנייה/מלפפון/תפוח אדמה → האדמה<br>
                    • בשר/דג/ביצה/מים → שהכל
                </div>
            </div>

            <div class="form-group">
                <label>הערות (אופציונלי)</label>
                <textarea name="notes" rows="3" 
                          placeholder="הערות נוספות..."><?= isset($_POST['notes']) ? htmlspecialchars($_POST['notes']) : '' ?></textarea>
            </div>

            <button type="submit" class="btn btn-primary">💾 שמור מאכל</button>
        </form>
    </div>
</body>
</html>
