<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}

/**
 * Blessings Admin - ממשק ניהול ברכות
 */
require 'config.php';

// טיפול במחיקה
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM blessings WHERE id = ?");
    $stmt->execute([$id]);
    header('Location: blessings_admin.php?msg=deleted');
    exit;
}

// שליפת כל הברכות
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
if (!empty($search)) {
    $stmt = $pdo->prepare("SELECT * FROM blessings WHERE food_name LIKE ? ORDER BY food_name");
    $stmt->execute(["%$search%"]);
} else {
    $stmt = $pdo->query("SELECT * FROM blessings ORDER BY food_name");
}
$blessings = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ניהול ברכות - סידור תפילה</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 30px;
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
            font-size: 2.5em;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s;
        }
        .back-link:hover {
            color: #5568d3;
        }
        .actions {
            display: flex;
            gap: 15px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #667eea;
            color: white;
        }
        .btn-primary:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        .btn-danger {
            background: #f56565;
            color: white;
            font-size: 14px;
            padding: 8px 16px;
        }
        .btn-danger:hover {
            background: #e53e3e;
        }
        .btn-edit {
            background: #48bb78;
            color: white;
            font-size: 14px;
            padding: 8px 16px;
        }
        .btn-edit:hover {
            background: #38a169;
        }
        .search-box {
            flex: 1;
            display: flex;
            gap: 10px;
        }
        .search-box input {
            flex: 1;
            padding: 12px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 16px;
        }
        .search-box input:focus {
            outline: none;
            border-color: #667eea;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        .alert-success {
            background: #c6f6d5;
            color: #22543d;
            border: 2px solid #9ae6b4;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: right;
            font-weight: bold;
        }
        td {
            padding: 12px;
            border-bottom: 1px solid #e2e8f0;
        }
        tr:hover {
            background: #f7fafc;
        }
        .category {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            background: #e2e8f0;
            color: #4a5568;
        }
        .blessing-text {
            font-size: 14px;
            color: #4a5568;
            max-width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .actions-cell {
            display: flex;
            gap: 10px;
        }
        .count {
            text-align: center;
            color: #718096;
            margin-bottom: 20px;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="admin.php" class="back-link">← חזרה לתפריט ראשי</a>
        
        <h1>🍎 ניהול ברכות</h1>

        <?php if (isset($_GET['msg'])): ?>
            <?php if ($_GET['msg'] === 'deleted'): ?>
                <div class="alert alert-success">✅ המאכל נמחק בהצלחה!</div>
            <?php elseif ($_GET['msg'] === 'added'): ?>
                <div class="alert alert-success">✅ המאכל נוסף בהצלחה!</div>
            <?php elseif ($_GET['msg'] === 'updated'): ?>
                <div class="alert alert-success">✅ המאכל עודכן בהצלחה!</div>
            <?php endif; ?>
        <?php endif; ?>

        <div class="actions">
            <a href="blessings_add.php" class="btn btn-primary">➕ הוסף מאכל חדש</a>
            <form method="get" class="search-box">
                <input type="text" name="search" placeholder="חפש מאכל..." value="<?= htmlspecialchars($search) ?>">
                <button type="submit" class="btn btn-primary">🔍 חפש</button>
                <?php if ($search): ?>
                    <a href="blessings_admin.php" class="btn btn-primary">✖️ נקה</a>
                <?php endif; ?>
            </form>
        </div>

        <div class="count">
            <strong>סך הכל: <?= count($blessings) ?> מאכלים</strong>
        </div>

        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>שם המאכל</th>
                    <th>ברכה ראשונה</th>
                    <th>ברכה אחרונה</th>
                    <th>קטגוריה</th>
                    <th>פעולות</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($blessings as $blessing): ?>
                    <tr>
                        <td><?= $blessing['id'] ?></td>
                        <td><strong><?= htmlspecialchars($blessing['food_name']) ?></strong></td>
                        <td><div class="blessing-text"><?= htmlspecialchars($blessing['blessing_before']) ?></div></td>
                        <td><div class="blessing-text"><?= htmlspecialchars($blessing['blessing_after']) ?></div></td>
                        <td><span class="category"><?= htmlspecialchars($blessing['category']) ?></span></td>
                        <td>
                            <div class="actions-cell">
                                <a href="blessings_edit.php?id=<?= $blessing['id'] ?>" class="btn btn-edit">✏️ ערוך</a>
                                <a href="?delete=<?= $blessing['id'] ?>" 
                                   onclick="return confirm('האם למחוק את <?= htmlspecialchars($blessing['food_name']) ?>?')" 
                                   class="btn btn-danger">🗑️ מחק</a>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <?php if (empty($blessings)): ?>
            <p style="text-align: center; padding: 40px; color: #718096; font-size: 18px;">
                <?= $search ? "לא נמצאו תוצאות לחיפוש '$search'" : 'אין מאכלים במערכת' ?>
            </p>
        <?php endif; ?>
    </div>
</body>
</html>
