<?php
/**
 * Blessings API - מחזיר רשימת ברכות מהדאטאבייס
 */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require 'config.php';

try {
    // פרמטר חיפוש אופציונלי
    $search = isset($_GET['search']) ? trim($_GET['search']) : '';

    if (!empty($search)) {
        // חיפוש לפי שם
        $stmt = $pdo->prepare("
            SELECT id, food_name, blessing_before, blessing_after, category
            FROM blessings
            WHERE food_name LIKE :search 
               OR food_name_normalized LIKE :search
            ORDER BY food_name
        ");
        $stmt->execute(['search' => "%$search%"]);
    } else {
        // כל הברכות
        $stmt = $pdo->query("
            SELECT id, food_name, blessing_before, blessing_after, category
            FROM blessings
            ORDER BY food_name
        ");
    }

    $blessings = $stmt->fetchAll();

    echo json_encode([
        'success' => true,
        'count' => count($blessings),
        'data' => $blessings,
        'timestamp' => date('c')
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Database error',
        'timestamp' => date('c')
    ], JSON_UNESCAPED_UNICODE);
}
?>
