<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}
require 'config.php';
$message = '';
if ($_POST) {
    $name = trim($_POST['name'] ?? '');
    if (isset($_POST['reset'])) {
        $name = null;
        $message = "השם אופס בהצלחה";
    } else {
        $message = "השם עודכן: " . ($name ?: "ריק");
    }
    $stmt = $pdo->prepare("UPDATE dedication SET full_name = ? WHERE id = 1");
    $stmt->execute([$name]);
}
$stmt = $pdo->query("SELECT full_name FROM dedication WHERE id = 1");
$current = $stmt->fetchColumn();
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ניהול הקדשה - סידור</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .box {
            max-width: 600px;
            margin: 40px auto;
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
            font-size: 2.5em;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s;
        }
        .back-link:hover {
            color: #5568d3;
        }
        input, button {
            padding: 14px;
            margin: 10px 0;
            width: 100%;
            font-size: 18px;
            border-radius: 8px;
            border: 2px solid #e2e8f0;
        }
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        button {
            background: #667eea;
            color: white;
            border: none;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s;
        }
        button:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        .reset {
            background: #f56565;
        }
        .reset:hover {
            background: #e53e3e;
        }
        .current {
            background: #e6fffa;
            padding: 20px;
            border-radius: 8px;
            font-size: 20px;
            text-align: center;
            margin: 20px 0;
            border: 2px solid #81e6d9;
        }
        .message {
            background: #c6f6d5;
            color: #22543d;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: bold;
            border: 2px solid #9ae6b4;
        }
    </style>
</head>
<body>
<div class="box">
    <a href="admin.php" class="back-link">← חזרה לתפריט ראשי</a>
    
    <h1>🕯️ ניהול הקדשה</h1>
    
    <div class="current">
        <strong>שם נוכחי:</strong><br>
        <?= $current ?: "עליזה אגוזי ז״ל (ברירת מחדל)" ?>
    </div>
    
    <?php if ($message): ?>
        <div class="message">✅ <?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    
    <form method="post">
        <input type="text" name="name" placeholder="הזן שם מלא (למשל: דוד חיים בן רחל)" value="<?= htmlspecialchars($current ?: '') ?>">
        <button type="submit">💾 עדכן שם</button>
    </form>
    
    <form method="post" onsubmit="return confirm('בטוח שברצונך לאפס לברירת מחדל?');">
        <input type="hidden" name="reset" value="1">
        <button type="submit" class="reset">🔄 איפוס – חזרה לברירת מחדל</button>
    </form>
</div>
</body>
</html>
