<?php
session_start();
require 'config.php';

if ($_POST) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // הסיסמה המוצפנת של "ADMIN" – תשנה רק אם אתה רוצה יוזר אחר
    $hash = '$2y$10$Q3.tjFZ2pIp9IYNLA/6X5u9K.gxV8INlaLebjP8.VNNRLR9YzUS2W'; // = כניסה עם ADMIN + 123456

    if ($username === 'Admin' && password_verify($password, $hash)) {
        $_SESSION['loggedin'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $error = "שם משתמש או סיסמה שגויים";
    }
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="utf-8">
    <title>כניסה - סידור לעילוי נשמת</title>
    <style>
        body { font-family: Arial; background: #f0f0f0; padding: 50px; }
        .login { max-width: 400px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        input, button { width: 100%; padding: 12px; margin: 10px 0; font-size: 16px; }
        button { background: #1976D2; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>
<div class="login">
    <h2>כניסה למערכת ניהול</h2>
    <?php if (isset($error)) echo "<p style='color:red'>$error</p>"; ?>
    <form method="post">
        <input type="text" name="username" placeholder="שם משתמש" required autofocus><br>
        <input type="password" name="password" placeholder="סיסמה" required><br>
        <button type="submit">כניסה</button>
    </form>
    <p><small>רמז: ADMIN + 123456</small></p>
</div>
</body>
</html>
