<?php
session_start();
if (!isset($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}
require 'config.php';

// --- הגדרות דפדוף (Pagination) ---
$records_per_page = 30; // כמה רשומות להציג בעמוד
$current_page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
if ($current_page < 1) $current_page = 1;

// --- לוגיקה לאיפוס סטטיסטיקות ---
if (isset($_GET['action']) && $_GET['action'] === 'reset') {
    $stmt = $pdo->exec("TRUNCATE TABLE app_sidur_stats");
    header('Location: stats_dashboard.php');
    exit;
}

// 1. ספירת סך הכל התקנות
$stmt = $pdo->query("SELECT COUNT(DISTINCT device_id) FROM app_sidur_stats WHERE event_type = 'install'");
$total_installs = $stmt->fetchColumn();

// 2. משתמשים פעילים היום
$stmt = $pdo->query("SELECT COUNT(DISTINCT device_id) FROM app_sidur_stats WHERE created_at >= CURDATE()");
$active_today = $stmt->fetchColumn();

// 3. חישוב סך הכל רשומות בטבלה (לצורך הדפדוף)
$stmt_count = $pdo->query("SELECT COUNT(*) FROM app_sidur_stats");
$total_records = $stmt_count->fetchColumn();
$total_pages = ceil($total_records / $records_per_page);

// חישוב ה-Offset (מאיפה להתחיל לשלוף)
$offset = ($current_page - 1) * $records_per_page;

// 4. שליפת הרשומות לפי העמוד הנוכחי
// שימוש ב-bindValue כדי להבטיח שה-LIMIT וה-OFFSET הם מספרים תקינים
$stmt = $pdo->prepare("SELECT * FROM app_sidur_stats ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $records_per_page, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$logs = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>סטטיסטיקות שימוש - סידור</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Arial, sans-serif; background: #f0f2f5; padding: 20px; margin: 0; }
        .container { max-width: 1200px; margin: 0 auto; }
        
        .header { 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            margin-bottom: 30px; 
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        
        .header h1 { margin: 0; font-size: 24px; color: #2d3748; }
        
        .header-actions { display: flex; gap: 10px; }
        .btn { padding: 10px 20px; text-decoration: none; border-radius: 8px; font-weight: bold; transition: background 0.3s; }
        .btn-back { background: #667eea; color: white; }
        .btn-back:hover { background: #5568d3; }
        .btn-reset { background: #fc8181; color: #742a2a; border: 1px solid #feb2b2; }
        .btn-reset:hover { background: #f56565; color: white; }

        /* כרטיסי מידע */
        .cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 40px; }
        .card { background: white; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); text-align: center; }
        .card h3 { color: #718096; font-size: 16px; margin-bottom: 10px; }
        .card .number { font-size: 42px; font-weight: bold; color: #2d3748; }
        .card.purple .number { color: #667eea; }
        .card.green .number { color: #48bb78; }

        /* טבלה */
        .table-container { background: white; padding: 20px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        table { width: 100%; border-collapse: collapse; }
        th { text-align: right; padding: 15px; background: #f7fafc; color: #4a5568; }
        td { padding: 12px; border-bottom: 1px solid #e2e8f0; color: #2d3748; }
        tr:hover { background: #f7fafc; }
        .badge { padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: bold; }
        .badge-install { background: #c6f6d5; color: #22543d; }
        .badge-open { background: #bee3f8; color: #2c5282; }
        .empty-state { text-align: center; padding: 40px; color: #718096; }

        /* עיצוב הדפדוף */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
            gap: 10px;
        }
        .pagination a {
            padding: 8px 16px;
            background: #e2e8f0;
            color: #4a5568;
            text-decoration: none;
            border-radius: 6px;
            transition: background 0.3s;
        }
        .pagination a:hover {
            background: #cbd5e0;
        }
        .pagination .current-page {
            font-weight: bold;
            color: #2d3748;
            padding: 0 10px;
        }
        .pagination .disabled {
            opacity: 0.5;
            pointer-events: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📊 מעקב וסטטיסטיקה</h1>
            <div class="header-actions">
                <a href="?action=reset" class="btn btn-reset" onclick="return confirm('האם אתה בטוח שברצונך לאפס את כל הנתונים?\nפעולה זו תמחק את כל היסטוריית השימוש וההתקנות ולא ניתנת לשחזור!')">🗑️ איפוס נתונים</a>
                <a href="admin.php" class="btn btn-back">← חזרה לראשי</a>
            </div>
        </div>

        <div class="cards">
            <div class="card purple">
                <h3>סך הכל התקנות</h3>
                <div class="number"><?= number_format($total_installs) ?></div>
            </div>
            <div class="card green">
                <h3>משתמשים פעילים היום</h3>
                <div class="number"><?= number_format($active_today) ?></div>
            </div>
        </div>

        <div class="table-container">
            <h3>לוג פעילות (מציג <?= count($logs) ?> רשומות בעמוד זה)</h3>
            
            <?php if (count($logs) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>זמן</th>
                        <th>סוג אירוע</th>
                        <th>דגם מכשיר</th>
                        <th>Device ID (חלקי)</th>
                        <th>IP</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td dir="ltr" style="text-align:right"><?= $log['created_at'] ?></td>
                            <td>
                                <?php if($log['event_type'] == 'install'): ?>
                                    <span class="badge badge-install">התקנה חדשה</span>
                                <?php else: ?>
                                    <span class="badge badge-open">פתיחת אפליקציה</span>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($log['device_model'] ?? '') ?></td>
                            <td>...<?= substr($log['device_id'], -6) ?></td>
                            <td><?= htmlspecialchars($log['ip_address'] ?? '') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <?php if ($total_pages > 1): ?>
            <div class="pagination">
                <?php if ($current_page > 1): ?>
                    <a href="?page=<?= $current_page - 1 ?>">→ הקודם</a>
                <?php else: ?>
                    <span class="disabled" style="padding: 8px 16px; background: #f7fafc; color: #a0aec0; border-radius: 6px;">→ הקודם</span>
                <?php endif; ?>

                <span class="current-page">עמוד <?= $current_page ?> מתוך <?= $total_pages ?></span>

                <?php if ($current_page < $total_pages): ?>
                    <a href="?page=<?= $current_page + 1 ?>">הבא ←</a>
                <?php else: ?>
                    <span class="disabled" style="padding: 8px 16px; background: #f7fafc; color: #a0aec0; border-radius: 6px;">הבא ←</span>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php else: ?>
                <div class="empty-state">
                    אין נתונים להצגה כרגע.
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
